(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4154,        114]*)
(*NotebookOutlinePosition[      4995,        141]*)
(*  CellTagsIndexPosition[      4951,        137]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \( (*\ 
      Gauss\ points\ for\ n = 
        8\ for\ the\ interval\ \((\(-1\), \ 1)\)\ \nare\ called\ gausspoints, 
      \ and\ those\ for\ the\ interval\ \((0, \ \[Pi])\)\ are\ called\ 
        newgausspoints\ \ *) \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\tNSolve[LegendreP[8, x] == 0, \ x]\)\)], "Input"],

Cell[BoxData[
    \({{x \[Rule] \(-0.960289856497536931`\)}, {
        x \[Rule] \(-0.796666477413626239`\)}, {
        x \[Rule] \(-0.52553240991632899`\)}, {
        x \[Rule] \(-0.183434642495649811`\)}, {
        x \[Rule] 0.183434642495649811`}, {x \[Rule] 0.52553240991632899`}, {
        x \[Rule] 0.796666477413626239`}, {x \[Rule] 0.960289856497536931`}}
      \)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(gausspoints = {\(-0.960289856497536931`\), \(-0.796666477413626239`\), 
        \(-0.52553240991632899`\), \(-0.183434642495649811`\), 
        0.183434642495649811`, 0.52553240991632899`, 0.796666477413626239`, 
        0.960289856497536931`}; \nf[a_] := \ \[Pi] \((1.  + a)\)/2\ ; \n
    newgausspoints = 
      Map[f, {\(-0.960289856497536931`\), \(-0.796666477413626239`\), 
          \(-0.52553240991632899`\), \(-0.183434642495649811`\), 
          0.183434642495649811`, 0.52553240991632899`, 0.796666477413626239`, 
          0.960289856497536931`}]\)], "Input"],

Cell[BoxData[
    \({0.0623765475501671851`, 0.319395550392942961`, 0.745291947686657074`, 
      1.28265786415579485`, 1.85893478943399852`, 2.39630070590313604`, 
      2.82219710319685024`, 3.07921610603962569`}\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\( (*\ These\ are\ gauss\ points\ for\ \((0, \[Pi])\)\ in\ radians\ *) 
      \n\n (*\ Now, \ 
      the\ \ gauss\ points\ for\ \((0, \[Pi])\)\ in\ degrees\ *) \)\)], 
  "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(g[a_] := \ 90*\((1 + a)\); \n\ 
    degreegausspoints = \n\t
      Map[g, {\(-0.960289856497536931`\), \(-0.796666477413626239`\), 
          \(-0.52553240991632899`\), \(-0.183434642495649811`\), 
          0.183434642495649811`, 0.52553240991632899`, 0.796666477413626239`, 
          0.960289856497536931`}]\)], "Input"],

Cell[BoxData[
    \({3.57391291522167442`, 18.3000170327736348`, 42.7020831075303952`, 
      73.4908821753915209`, 106.509117824608479`, 137.297916892469595`, 
      161.699982967226363`, 176.426087084778293`}\)], "Output"]
}, Open  ]],

Cell[BoxData[""], "Input"]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{520, 509},
WindowMargins->{{82, Automatic}, {-13, Automatic}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 250, 5, 59, "Input"],

Cell[CellGroupData[{
Cell[1984, 58, 72, 1, 27, "Input"],
Cell[2059, 61, 384, 7, 56, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2480, 73, 590, 9, 187, "Input"],
Cell[3073, 84, 228, 3, 41, "Output"]
}, Open  ]],
Cell[3316, 90, 198, 4, 59, "Input"],

Cell[CellGroupData[{
Cell[3539, 98, 343, 6, 123, "Input"],
Cell[3885, 106, 224, 3, 41, "Output"]
}, Open  ]],
Cell[4124, 112, 26, 0, 27, "Input"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

